/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import net.sourceforge.texlipse.texparser.lexer.LexerException;
import net.sourceforge.texlipse.texparser.node.EOF;
import net.sourceforge.texlipse.texparser.node.TArgument;
import net.sourceforge.texlipse.texparser.node.TBverbatim;
import net.sourceforge.texlipse.texparser.node.TCbegin;
import net.sourceforge.texlipse.texparser.node.TCbib;
import net.sourceforge.texlipse.texparser.node.TCbibstyle;
import net.sourceforge.texlipse.texparser.node.TCchapter;
import net.sourceforge.texlipse.texparser.node.TCcite;
import net.sourceforge.texlipse.texparser.node.TCend;
import net.sourceforge.texlipse.texparser.node.TCinclude;
import net.sourceforge.texlipse.texparser.node.TCinput;
import net.sourceforge.texlipse.texparser.node.TClabel;
import net.sourceforge.texlipse.texparser.node.TCnew;
import net.sourceforge.texlipse.texparser.node.TCommentline;
import net.sourceforge.texlipse.texparser.node.TCpackage;
import net.sourceforge.texlipse.texparser.node.TCparagraph;
import net.sourceforge.texlipse.texparser.node.TCpart;
import net.sourceforge.texlipse.texparser.node.TCpbib;
import net.sourceforge.texlipse.texparser.node.TCpindex;
import net.sourceforge.texlipse.texparser.node.TCref;
import net.sourceforge.texlipse.texparser.node.TCrenew;
import net.sourceforge.texlipse.texparser.node.TCsection;
import net.sourceforge.texlipse.texparser.node.TCspace;
import net.sourceforge.texlipse.texparser.node.TCssection;
import net.sourceforge.texlipse.texparser.node.TCsssection;
import net.sourceforge.texlipse.texparser.node.TCsymbol;
import net.sourceforge.texlipse.texparser.node.TCverb;
import net.sourceforge.texlipse.texparser.node.TCword;
import net.sourceforge.texlipse.texparser.node.TEverbatim;
import net.sourceforge.texlipse.texparser.node.TLBrace;
import net.sourceforge.texlipse.texparser.node.TLBracket;
import net.sourceforge.texlipse.texparser.node.TOptargument;
import net.sourceforge.texlipse.texparser.node.TRBrace;
import net.sourceforge.texlipse.texparser.node.TRBracket;
import net.sourceforge.texlipse.texparser.node.TSkippedArea;
import net.sourceforge.texlipse.texparser.node.TStar;
import net.sourceforge.texlipse.texparser.node.TTaskcomment;
import net.sourceforge.texlipse.texparser.node.TVtext;
import net.sourceforge.texlipse.texparser.node.TWhitespace;
import net.sourceforge.texlipse.texparser.node.TWord;
import net.sourceforge.texlipse.texparser.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.NORMAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    static {
        try {
            int j;
            DataInputStream s = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int length = s.readInt();
            gotoTable = new int[length][][][];
            int i = 0;
            while (i < gotoTable.length) {
                length = s.readInt();
                Lexer.gotoTable[i] = new int[length][][];
                j = 0;
                while (j < gotoTable[i].length) {
                    length = s.readInt();
                    Lexer.gotoTable[i][j] = new int[length][3];
                    int k = 0;
                    while (k < gotoTable[i][j].length) {
                        int l = 0;
                        while (l < 3) {
                            Lexer.gotoTable[i][j][k][l] = s.readInt();
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            length = s.readInt();
            accept = new int[length][];
            i = 0;
            while (i < accept.length) {
                length = s.readInt();
                Lexer.accept[i] = new int[length];
                j = 0;
                while (j < accept[i].length) {
                    Lexer.accept[i][j] = s.readInt();
                    ++j;
                }
                ++i;
            }
            s.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block212: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block212;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                            break;
                        }
                        case 5: {
                            this.state = State.VERB;
                            break;
                        }
                        case 4: {
                            this.state = State.VERBATIM;
                        }
                    }
                    return token;
                }
                case 1: {
                    Token token = this.new1(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 2: {
                    Token token = this.new2(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 3: {
                    Token token = this.new3(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 4: {
                    Token token = this.new4(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 5: {
                    Token token = this.new5(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 6: {
                    Token token = this.new6(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 7: {
                    Token token = this.new7(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 9: {
                    Token token = this.new9(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 10: {
                    Token token = this.new10(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 11: {
                    Token token = this.new11(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 12: {
                    Token token = this.new12(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 13: {
                    Token token = this.new13(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 14: {
                    Token token = this.new14(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 15: {
                    Token token = this.new15(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 17: {
                    Token token = this.new17(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 18: {
                    Token token = this.new18(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 19: {
                    Token token = this.new19(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 20: {
                    Token token = this.new20(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 21: {
                    Token token = this.new21(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.VERBATIM;
                            break;
                        }
                        case 0: {
                            this.state = State.VERBATIM;
                        }
                    }
                    return token;
                }
                case 22: {
                    Token token = this.new22(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 4: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 23: {
                    Token token = this.new23(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 5: {
                            this.state = State.VERB;
                            break;
                        }
                        case 4: {
                            this.state = State.VERBATIM;
                        }
                    }
                    return token;
                }
                case 24: {
                    Token token = this.new24(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.VERB;
                            break;
                        }
                        case 0: {
                            this.state = State.VERB;
                        }
                    }
                    return token;
                }
                case 25: {
                    Token token = this.new25(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                        }
                    }
                    return token;
                }
                case 26: {
                    Token token = this.new26(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 27: {
                    Token token = this.new27(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                        }
                    }
                    return token;
                }
                case 28: {
                    Token token = this.new28(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 1: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 29: {
                    Token token = this.new29(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 1: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 30: {
                    Token token = this.new30(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.OPTCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 31: {
                    Token token = this.new31(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 32: {
                    Token token = this.new32(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 33: {
                    Token token = this.new33(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 1: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 34: {
                    Token token = this.new34(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 2: {
                            this.state = State.BLOCKCAPT;
                            break;
                        }
                        case 1: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 3: {
                            this.state = State.OPTCAPT;
                        }
                    }
                    return token;
                }
                case 35: {
                    Token token = this.new35(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 36: {
                    Token token = this.new36(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 37: {
                    Token token = this.new37(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 38: {
                    Token token = this.new38(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.COMCAPT;
                            break;
                        }
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(String text, int line, int pos) {
        return new TWhitespace(text, line, pos);
    }

    Token new1(int line, int pos) {
        return new TCpart(line, pos);
    }

    Token new2(int line, int pos) {
        return new TCchapter(line, pos);
    }

    Token new3(int line, int pos) {
        return new TCsection(line, pos);
    }

    Token new4(int line, int pos) {
        return new TCssection(line, pos);
    }

    Token new5(int line, int pos) {
        return new TCsssection(line, pos);
    }

    Token new6(int line, int pos) {
        return new TCparagraph(line, pos);
    }

    Token new7(String text, int line, int pos) {
        return new TCbib(text, line, pos);
    }

    Token new8(int line, int pos) {
        return new TCbibstyle(line, pos);
    }

    Token new9(int line, int pos) {
        return new TClabel(line, pos);
    }

    Token new10(String text, int line, int pos) {
        return new TCref(text, line, pos);
    }

    Token new11(String text, int line, int pos) {
        return new TCcite(text, line, pos);
    }

    Token new12(int line, int pos) {
        return new TCbegin(line, pos);
    }

    Token new13(int line, int pos) {
        return new TCend(line, pos);
    }

    Token new14(int line, int pos) {
        return new TCinput(line, pos);
    }

    Token new15(int line, int pos) {
        return new TCinclude(line, pos);
    }

    Token new16(String text, int line, int pos) {
        return new TCnew(text, line, pos);
    }

    Token new17(int line, int pos) {
        return new TCrenew(line, pos);
    }

    Token new18(int line, int pos) {
        return new TCpackage(line, pos);
    }

    Token new19(int line, int pos) {
        return new TCpindex(line, pos);
    }

    Token new20(String text, int line, int pos) {
        return new TCpbib(text, line, pos);
    }

    Token new21(String text, int line, int pos) {
        return new TBverbatim(text, line, pos);
    }

    Token new22(String text, int line, int pos) {
        return new TEverbatim(text, line, pos);
    }

    Token new23(String text, int line, int pos) {
        return new TVtext(text, line, pos);
    }

    Token new24(String text, int line, int pos) {
        return new TCverb(text, line, pos);
    }

    Token new25(String text, int line, int pos) {
        return new TArgument(text, line, pos);
    }

    Token new26(String text, int line, int pos) {
        return new TOptargument(text, line, pos);
    }

    Token new27(int line, int pos) {
        return new TStar(line, pos);
    }

    Token new28(int line, int pos) {
        return new TLBrace(line, pos);
    }

    Token new29(int line, int pos) {
        return new TRBrace(line, pos);
    }

    Token new30(int line, int pos) {
        return new TLBracket(line, pos);
    }

    Token new31(int line, int pos) {
        return new TRBracket(line, pos);
    }

    Token new32(String text, int line, int pos) {
        return new TCword(text, line, pos);
    }

    Token new33(String text, int line, int pos) {
        return new TCsymbol(text, line, pos);
    }

    Token new34(String text, int line, int pos) {
        return new TCspace(text, line, pos);
    }

    Token new35(String text, int line, int pos) {
        return new TWord(text, line, pos);
    }

    Token new36(String text, int line, int pos) {
        return new TSkippedArea(text, line, pos);
    }

    Token new37(String text, int line, int pos) {
        return new TTaskcomment(text, line, pos);
    }

    Token new38(String text, int line, int pos) {
        return new TCommentline(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        int i = length - 1;
        while (i >= acceptLength) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
            --i;
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        int i = length - 1;
        while (i >= 0) {
            this.eof = false;
            this.in.unread(text.charAt(i));
            --i;
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        int i = 0;
        while (i < acceptLength) {
            s.append(this.text.charAt(i));
            ++i;
        }
        return s.toString();
    }

    public static class State {
        public static final State NORMAL = new State(0);
        public static final State COMCAPT = new State(1);
        public static final State BLOCKCAPT = new State(2);
        public static final State OPTCAPT = new State(3);
        public static final State VERBATIM = new State(4);
        public static final State VERB = new State(5);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

