/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.texlipse.model.DocumentReference;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.model.ParseErrorMessage;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.texparser.LatexLexer;
import net.sourceforge.texlipse.texparser.LatexParser;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import net.sourceforge.texlipse.texparser.lexer.LexerException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexParser {
    private IDocument inputDoc;
    private LatexParser lparser;
    private List<ParseErrorMessage> errors;
    private boolean fatalErrors;
    private String preamble;

    public TexParser(IDocument input) {
        this.inputDoc = input;
        this.lparser = new LatexParser();
        this.fatalErrors = false;
    }

    private String rmTrailingWhitespace(String input) {
        int lastChar = input.length() - 1;
        while (lastChar >= 0 && Character.isWhitespace(input.charAt(lastChar))) {
            --lastChar;
        }
        if (++lastChar < input.length()) {
            return input.substring(0, lastChar);
        }
        return input;
    }

    static String extractLaTeXPreamble(String input) {
        IRegion region = LatexParserUtils.findBeginEnvironment(input, "document", 0);
        if (region != null) {
            return input.substring(0, region.getOffset() + region.getLength());
        }
        return null;
    }

    private void extractPreamble(String input) {
        this.preamble = TexParser.extractLaTeXPreamble(input);
    }

    public void parseDocument(boolean checkForMissingSections) throws IOException {
        this.parseDocument(this.inputDoc.get(), checkForMissingSections);
    }

    public void parseDocument(String input, boolean checkForMissingSections) throws IOException {
        input = this.rmTrailingWhitespace(input);
        this.extractPreamble(input);
        try {
            LatexLexer lexer = new LatexLexer(new PushbackReader(new StringReader(input), 4096));
            if (this.preamble != null) {
                OutlineNode on = new OutlineNode("Preamble", 14, 1, null);
                this.lparser.parse(lexer, on, checkForMissingSections);
            } else {
                this.lparser.parse(lexer, checkForMissingSections);
            }
            this.errors = this.lparser.getErrors();
            this.fatalErrors = this.lparser.isFatalErrors();
        }
        catch (LexerException e) {
            String msg = e.getMessage();
            int first = msg.indexOf(91);
            int last = msg.indexOf(93);
            String numseq = msg.substring(first + 1, last);
            String[] numbers = numseq.split(",");
            this.errors = new ArrayList<ParseErrorMessage>(1);
            this.errors.add(new ParseErrorMessage(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), 2, msg.substring(last + 2), 2));
            this.fatalErrors = true;
        }
    }

    public ArrayList<OutlineNode> getOutlineTree() {
        return this.lparser.getOutlineTree();
    }

    public List<ReferenceEntry> getLabels() {
        List<ReferenceEntry> labels = this.lparser.getLabels();
        for (ReferenceEntry label : labels) {
            label.setLabelInfo(this.inputDoc.get());
        }
        return labels;
    }

    public List<DocumentReference> getCites() {
        return this.lparser.getCites();
    }

    public List<ParseErrorMessage> getErrors() {
        return this.errors;
    }

    public String[] getBibs() {
        return this.lparser.getBibs();
    }

    public String getBibstyle() {
        return this.lparser.getBibstyle();
    }

    public boolean isBiblatexMode() {
        return this.lparser.isBiblatexMode();
    }

    public String getBiblatexBackend() {
        return this.lparser.getBiblatexBackend();
    }

    public boolean isLocalBib() {
        return this.lparser.isLocalBib();
    }

    public String getPreamble() {
        return this.preamble;
    }

    public boolean isIndex() {
        return this.lparser.isIndex();
    }

    public boolean isFatalErrors() {
        return this.fatalErrors;
    }

    public List<DocumentReference> getRefs() {
        return this.lparser.getRefs();
    }

    public ArrayList<TexCommandEntry> getCommands() {
        return this.lparser.getCommands();
    }

    public List<ParseErrorMessage> getTasks() {
        return this.lparser.getTasks();
    }

    public List<OutlineNode> getInputs() {
        return this.lparser.getInputs();
    }
}

