/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.texlipse.model.AbstractEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartialRetriever {
    public static int getEntry(String entryname, List<? extends AbstractEntry> entries, boolean lowerCase) {
        if (entries == null || entries.size() == 0) {
            return -1;
        }
        String lEntryname = entryname.toLowerCase();
        int start = 0;
        int end = entries.size();
        while (end - start > 1 && !entries.get((start + end) / 2).getkey(lowerCase).equals(lEntryname)) {
            int c = entries.get((start + end) / 2).getkey(lowerCase).compareTo(lEntryname);
            if (c < 0) {
                start = (start + end) / 2;
                continue;
            }
            end = (start + end) / 2;
        }
        if (lowerCase) {
            int m = (start + end) / 2;
            if (!entries.get(m).getkey(lowerCase).equals(lEntryname)) {
                return -1;
            }
            --m;
            while (m >= 0 && entries.get(m).getkey(lowerCase).equals(lEntryname)) {
                --m;
            }
            ++m;
            while (m < entries.size() && entries.get(m).getkey(lowerCase).equals(lEntryname)) {
                if (entries.get((int)m).key.equals(entryname)) {
                    return m;
                }
                ++m;
            }
            return -1;
        }
        if (entries.get((start + end) / 2).getkey(lowerCase).equals(lEntryname)) {
            return (start + end) / 2;
        }
        return -1;
    }

    protected int[] getCompletionsBin(String start, List<? extends AbstractEntry> entries, boolean lowerCase) {
        int[] nArray = new int[2];
        nArray[1] = entries.size();
        return this.getCompletionsBin(start, entries, nArray, lowerCase);
    }

    protected int[] getCompletionsBin(String start, AbstractEntry[] entries) {
        int[] nArray = new int[2];
        nArray[1] = entries.length;
        return this.getCompletionsBin(start, Arrays.asList(entries), nArray, false);
    }

    protected int[] getCompletionsBin(String start, List<? extends AbstractEntry> entries, int[] initBounds, boolean lowerCase) {
        int[] bounds = new int[]{-1, -1};
        int left = initBounds[0];
        int right = initBounds[1] - 1;
        int middle = right / 2;
        if (left > right) {
            return bounds;
        }
        if (lowerCase) {
            start = start.toLowerCase();
        }
        if (entries.get(left).getkey(lowerCase).startsWith(start)) {
            right = middle = left;
        }
        while (left < middle) {
            if (entries.get(middle).getkey(lowerCase).compareTo(start) >= 0) {
                right = middle;
                middle = (left + middle) / 2;
                continue;
            }
            left = middle;
            middle = (middle + right) / 2;
        }
        if (!entries.get(right).getkey(lowerCase).startsWith(start)) {
            return bounds;
        }
        bounds[0] = right;
        left = right;
        right = initBounds[1] - 1;
        if (entries.get(right).getkey(lowerCase).startsWith(start)) {
            bounds[1] = right + 1;
            return bounds;
        }
        middle = (left + right) / 2;
        while (left < middle) {
            if (entries.get(middle).getkey(lowerCase).startsWith(start)) {
                left = middle;
                middle = (right + middle) / 2;
                continue;
            }
            right = middle;
            middle = (middle + left) / 2;
        }
        bounds[1] = right;
        return bounds;
    }
}

