/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexAutoIndentStrategy;
import net.sourceforge.texlipse.editor.TexCompletionProposal;
import net.sourceforge.texlipse.extension.BibProvider;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.ReferenceManager;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.model.TexDocumentModel;
import net.sourceforge.texlipse.model.TexStyleCompletionManager;
import net.sourceforge.texlipse.spelling.SpellChecker;
import net.sourceforge.texlipse.templates.TexContextType;
import net.sourceforge.texlipse.templates.TexTemplateCompletion;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.HippieProposalProcessor;

public class TexCompletionProcessor
implements IContentAssistProcessor {
    private TexTemplateCompletion templatesCompletion = new TexTemplateCompletion(TexContextType.TEX_CONTEXT_TYPE);
    private TexDocumentModel model;
    private ReferenceManager refManager;
    private ISourceViewer fviewer;
    private TexStyleCompletionManager styleManager;
    public static final int assistLineLength = 60;
    private final HippieProposalProcessor hippie = new HippieProposalProcessor();
    private static final Pattern comCapt = Pattern.compile("([a-zA-Z]+)\\s*(?:\\[.*?\\]\\s*)?");

    public TexCompletionProcessor(TexDocumentModel tdm, ISourceViewer viewer) {
        this.model = tdm;
        this.fviewer = viewer;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.refManager == null) {
            this.refManager = this.model.getRefMana();
        }
        this.model.removeStatusLineErrorMessage();
        IDocument doc = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y > 0) {
            try {
                String text = doc.get(selectedRange.x, selectedRange.y);
                return this.computeStyleProposals(text, selectedRange);
            }
            catch (BadLocationException badLocationException) {}
        }
        try {
            int lineStartOffset = doc.getLineOffset(doc.getLineOfOffset(offset));
            String lineStart = doc.get(lineStartOffset, offset - lineStartOffset);
            ICompletionProposal[] proposals = null;
            ICompletionProposal[] templateProposals = this.computeTemplateCompletions(offset, lineStart, viewer);
            if (!(lineStart.length() >= 2 && lineStart.endsWith("\\\\") || lineStart.length() <= 0)) {
                int seqStartIdx = this.resolveCompletionStart(lineStart, lineStart.length() - 1);
                String seqStart = lineStart.substring(seqStartIdx);
                if (seqStart.startsWith("\\")) {
                    String replacement = seqStart.substring(1);
                    proposals = this.computeCommandCompletions(offset, replacement.length(), replacement);
                } else if (seqStart.startsWith("{")) {
                    proposals = this.resolveReferenceCompletions(lineStart, offset, seqStart);
                    if (proposals == null) {
                        proposals = SpellChecker.getSpellingProposal(offset, this.fviewer);
                        if (proposals != null && proposals.length > 0) {
                            return proposals;
                        }
                        proposals = this.hippie.computeCompletionProposals((ITextViewer)this.fviewer, offset);
                    }
                } else if (seqStart.length() > 0) {
                    proposals = SpellChecker.getSpellingProposal(offset, this.fviewer);
                    if (proposals != null && proposals.length > 0) {
                        return proposals;
                    }
                    proposals = this.hippie.computeCompletionProposals((ITextViewer)this.fviewer, offset);
                }
            }
            if (proposals != null) {
                ICompletionProposal[] value = new ICompletionProposal[proposals.length + templateProposals.length];
                System.arraycopy(templateProposals, 0, value, 0, templateProposals.length);
                System.arraycopy(proposals, 0, value, templateProposals.length, proposals.length);
                return value;
            }
            if (templateProposals.length == 0) {
                this.model.setStatusLineErrorMessage(" No completions available.");
            }
            return templateProposals;
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexCompletionProcessor: ", e);
            return new ICompletionProposal[0];
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y > 0) {
            if (this.styleManager == null) {
                this.styleManager = TexStyleCompletionManager.getInstance();
            }
            return this.styleManager.getStyleContext();
        }
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'{', '\\'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    private int resolveCompletionStart(String doc, int offset) {
        while (offset > 0) {
            if (Character.isWhitespace(doc.charAt(offset)) || doc.charAt(offset) == '}' || doc.charAt(offset) == '{' || doc.charAt(offset) == '\\') break;
            --offset;
        }
        return offset;
    }

    private ICompletionProposal[] resolveReferenceCompletions(String line, int offset, String lineEnd) {
        int lastIndex = line.lastIndexOf(92);
        if (lastIndex == -1) {
            return null;
        }
        String fullCommand = line.substring(lastIndex + 1, line.length() - lineEnd.length());
        Matcher m = comCapt.matcher(fullCommand);
        if (!m.matches()) {
            return null;
        }
        String command = m.group(1);
        String replacement = lineEnd.lastIndexOf(44) != -1 ? lineEnd.substring(lineEnd.lastIndexOf(44) + 1) : lineEnd.substring(1);
        ICompletionProposal[] proposals = null;
        if (command.indexOf("cite") > -1) {
            proposals = this.computeBibCompletions(offset, replacement.length(), replacement);
        } else if (command.indexOf("ref") > -1) {
            proposals = this.computeRefCompletions(offset, replacement.length(), replacement);
        }
        return proposals;
    }

    private ICompletionProposal[] computeBibCompletions(int offset, int replacementLength, String prefix) {
        IConfigurationElement[] configuration;
        List<Object> resultAsList = new ArrayList<CompletionProposal>();
        List<ReferenceEntry> bibEntries = this.refManager.getCompletionsBib(prefix);
        if (bibEntries != null) {
            int i = 0;
            while (i < bibEntries.size()) {
                ReferenceEntry bib = bibEntries.get(i);
                String infoText = bib.info.length() > 60 ? TexCompletionProcessor.wrapString(bib.info, 60) : bib.info;
                resultAsList.add(new CompletionProposal(bib.key, offset - replacementLength, replacementLength, bib.key.length(), null, bib.key, null, infoText));
                ++i;
            }
        }
        if ((configuration = Platform.getExtensionRegistry().getConfigurationElementsFor("net.sourceforge.texlipse.CiteAutocompleteExtension")).length > 0) {
            IConfigurationElement[] iConfigurationElementArray = configuration;
            int n = configuration.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                try {
                    BibProvider prov = (BibProvider)elem.createExecutableExtension("class");
                    resultAsList = prov.getCompletions(offset, replacementLength, prefix, this.refManager.getBibContainer());
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        }
        if (resultAsList == null || resultAsList.size() == 0) {
            return null;
        }
        ICompletionProposal[] result = new ICompletionProposal[resultAsList.size()];
        return resultAsList.toArray(result);
    }

    private ICompletionProposal[] computeRefCompletions(int offset, int replacementLength, String prefix) {
        List<ReferenceEntry> refEntries = this.refManager.getCompletionsRef(prefix);
        if (refEntries == null) {
            return null;
        }
        ICompletionProposal[] result = new ICompletionProposal[refEntries.size()];
        int i = 0;
        while (i < refEntries.size()) {
            String infoText = null;
            ReferenceEntry ref = refEntries.get(i);
            if (ref.info != null) {
                infoText = ref.info.length() > 60 ? TexCompletionProcessor.wrapString(ref.info, 60) : ref.info;
            }
            result[i] = new CompletionProposal(ref.key, offset - replacementLength, replacementLength, ref.key.length(), null, ref.key, null, infoText);
            ++i;
        }
        return result;
    }

    static String environmentEnd(String doc, int offset) {
        int o = offset;
        while ((o = doc.lastIndexOf("\\begin", o)) >= 0) {
            String envName;
            IRegion r2;
            String command;
            IRegion r = LatexParserUtils.getCommand(doc, o + 1);
            if (r != null && "\\begin".equals(command = doc.substring(r.getOffset(), r.getOffset() + r.getLength())) && (r2 = LatexParserUtils.getCommandArgument(doc, o)) != null && TexAutoIndentStrategy.needsEnd(envName = doc.substring(r2.getOffset(), r2.getOffset() + r2.getLength()), doc, r.getOffset())) {
                return "end{" + envName + "}";
            }
            --o;
        }
        return null;
    }

    private ICompletionProposal[] computeCommandCompletions(int offset, int replacementLength, String prefix) {
        int start;
        ICompletionProposal[] result;
        String endString;
        List<TexCommandEntry> comEntries = this.refManager.getCompletionsCom(prefix, 1);
        if (comEntries == null) {
            return null;
        }
        CompletionProposal cp = null;
        if (("\\".equals(prefix) || "end".startsWith(prefix)) && (endString = TexCompletionProcessor.environmentEnd(this.fviewer.getDocument().get(), offset)) != null) {
            cp = new CompletionProposal(endString, offset - replacementLength, replacementLength, endString.length());
        }
        if (cp == null) {
            result = new ICompletionProposal[comEntries.size()];
            start = 0;
        } else {
            result = new ICompletionProposal[comEntries.size() + 1];
            result[0] = cp;
            start = 1;
        }
        int i = 0;
        while (i < comEntries.size()) {
            result[i + start] = new TexCompletionProposal(comEntries.get(i), offset - replacementLength, replacementLength, this.fviewer);
            ++i;
        }
        return result;
    }

    private ICompletionProposal[] computeTemplateCompletions(int offset, String lineStart, ITextViewer viewer) {
        int t = lineStart.lastIndexOf(32);
        if (t < lineStart.lastIndexOf(9)) {
            t = lineStart.lastIndexOf(9);
        }
        String replacement = lineStart.substring(t + 1);
        ArrayList returnProposals = this.templatesCompletion.addTemplateProposals(viewer, offset, replacement);
        ICompletionProposal[] proposals = new ICompletionProposal[returnProposals.size()];
        returnProposals.toArray(proposals);
        return proposals;
    }

    public static String wrapString(String input, int width) {
        StringBuffer sbout = new StringBuffer();
        String[] paragraphs = input.split("\r\n|\n|\r");
        int i = 0;
        while (i < paragraphs.length) {
            if (paragraphs[i].length() < width) {
                sbout.append(paragraphs[i]);
                sbout.append("\n");
            } else {
                String[] words = paragraphs[i].split("\\s");
                int currLength = 0;
                int j = 0;
                while (j < words.length) {
                    if (words[j].length() + currLength <= width || currLength == 0) {
                        if (currLength > 0) {
                            sbout.append(" ");
                        }
                        sbout.append(words[j]);
                        currLength += 1 + words[j].length();
                    } else {
                        sbout.append("\n");
                        sbout.append(words[j]);
                        currLength = words[j].length();
                    }
                    ++j;
                }
                sbout.append("\n");
            }
            ++i;
        }
        return sbout.toString();
    }

    private ICompletionProposal[] computeStyleProposals(String selectedText, Point selectedRange) {
        if (this.styleManager == null) {
            this.styleManager = TexStyleCompletionManager.getInstance();
        }
        return this.styleManager.getStyleCompletions(selectedText, selectedRange);
    }
}

