/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.CollectionParser;
import org.mvel2.util.ParseTools;

public class InlineCollectionNode
extends ASTNode {
    private Object collectionGraph;
    int trailingStart;
    int trailingOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InlineCollectionNode(char[] expr, int start, int end2, int fields2, ParserContext pctx) {
        super(expr, start, end2, fields2 | 0x400, pctx);
        if ((fields2 & 0x10) != 0) {
            this.parseGraph(true, null, pctx);
            try {
                AccessorOptimizer ao = OptimizerFactory.getThreadAccessorOptimizer();
                this.accessor = ao.optimizeCollection(pctx, this.collectionGraph, this.egressType, expr, this.trailingStart, this.trailingOffset, null, null, null);
                this.egressType = ao.getEgressType();
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InlineCollectionNode(char[] expr, int start, int end2, int fields2, Class type, ParserContext pctx) {
        super(expr, start, end2, fields2 | 0x400, pctx);
        this.egressType = type;
        if ((fields2 & 0x10) != 0) {
            try {
                this.parseGraph(true, type, pctx);
                AccessorOptimizer ao = OptimizerFactory.getThreadAccessorOptimizer();
                this.accessor = ao.optimizeCollection(pctx, this.collectionGraph, this.egressType, expr, this.trailingStart, this.trailingOffset, null, null, null);
                this.egressType = ao.getEgressType();
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.accessor.getValue(ctx, thisValue, factory);
        }
        try {
            AccessorOptimizer ao = OptimizerFactory.getThreadAccessorOptimizer();
            if (this.collectionGraph == null) {
                this.parseGraph(true, null, null);
            }
            this.accessor = ao.optimizeCollection(this.pCtx, this.collectionGraph, this.egressType, this.expr, this.trailingStart, this.trailingOffset, ctx, thisValue, factory);
            this.egressType = ao.getEgressType();
            Object object = this.accessor.getValue(ctx, thisValue, factory);
            return object;
        }
        finally {
            OptimizerFactory.clearThreadAccessorOptimizer();
        }
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        this.parseGraph(false, this.egressType, this.pCtx);
        return this.execGraph(this.collectionGraph, this.egressType, ctx, factory);
    }

    private void parseGraph(boolean compile, Class type, ParserContext pCtx) {
        CollectionParser parser = new CollectionParser();
        this.collectionGraph = type == null ? ((List)parser.parseCollection(this.expr, this.start, this.offset, compile, pCtx)).get(0) : ((List)parser.parseCollection(this.expr, this.start, this.offset, compile, type, pCtx)).get(0);
        this.trailingStart = parser.getCursor() + 2;
        this.trailingOffset = this.offset - (this.trailingStart - this.start);
        if (this.egressType == null) {
            this.egressType = this.collectionGraph.getClass();
        }
    }

    private Object execGraph(Object o, Class type, Object ctx, VariableResolverFactory factory) {
        if (o instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>(((List)o).size());
            for (Object item : (List)o) {
                list.add(this.execGraph(item, type, ctx, factory));
            }
            return list;
        }
        if (o instanceof Map) {
            HashMap<Object, Object> map2 = new HashMap<Object, Object>();
            for (Object item : ((Map)o).keySet()) {
                map2.put(this.execGraph(item, type, ctx, factory), this.execGraph(((Map)o).get(item), type, ctx, factory));
            }
            return map2;
        }
        if (o instanceof Object[]) {
            int dim = 0;
            if (type != null) {
                String nm = type.getName();
                while (nm.charAt(dim) == '[') {
                    ++dim;
                }
            } else {
                type = Object[].class;
                dim = 1;
            }
            Object newArray = Array.newInstance(ParseTools.getSubComponentType(type), ((Object[])o).length);
            try {
                Class cls = dim > 1 ? ParseTools.findClass(null, ParseTools.repeatChar('[', dim - 1) + "L" + ParseTools.getBaseComponentType(type).getName() + ";", this.pCtx) : type;
                int c = 0;
                for (Object item : (Object[])o) {
                    Array.set(newArray, c++, this.execGraph(item, cls, ctx, factory));
                }
                return newArray;
            }
            catch (IllegalArgumentException e) {
                throw new CompileException("type mismatch in array", this.expr, this.start, e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("this error should never throw:" + ParseTools.getBaseComponentType(type).getName(), e);
            }
        }
        if (type.isArray()) {
            return MVEL.eval((String)o, ctx, factory, ParseTools.getBaseComponentType(type));
        }
        return MVEL.eval((String)o, ctx, factory);
    }
}

