{$IFDEF WINDOWS}
{$N-,V-,W-,G+,S+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

Unit bibfile;


Interface
uses
{$IFDEF WINDOWS}
  WinDos, WinProcs, strings, Wobjects, WinTypes,
{$ELSE}
  Dos, objects,
{$ENDIF}
  bibvars, bibstrg, streams, bibwild, lfnunit;

Const
  K1:    LongInt = 1024;
  K16:   LongInt = 16384;
  K64:   LongInt = 65536;
  KGiga: Longint = 1024*1024*1024;

  NormalFileAttr = AnyFile and (not (Directory or SysFile));

  SEM_FailCriticalErrors = $0001;
  SEM_NoOpenFileErrorBox = $8000;

  Logging_on: boolean =false;

Var
  UnixDrives: string[26];
  ReachedEol: boolean;

function  DriveSize(dr: char): Longint; { -1 not found, 1=>1 Giga }
function  DriveFree(dr: char): Longint; { -1 not found, 1=>1 Giga }
{$IFNDEF WINDOWS}
function  SetHandleCount(Nhandles: WORD): word;
{$ENDIF}
function  IsDirName(S: string): boolean;
function  IsFileName(S: string): boolean;
function  Ready_Drive(ch: char): boolean;
function  FileSize(S: string): LongInt;
function  GetFileTime(fname: string): longint;
procedure Unique(path: string; Var fname: string);
function  exist_ems: Boolean;
function  exist_xms: Boolean;
function  FreeSpace(fname: string): LongInt;
function  ClusterSize(fname: string): longint;
procedure FindFile(var S: string; name: string; dirs: string);
function  IsUnixFile(var f: text; fname: string): boolean;
function  IsUnixStream(f: PStream; fname: string): boolean;
procedure SkipOneLine(var f: text; unix: boolean);
procedure ReadString(var f: text; var s: string; unix: boolean);
procedure ReadLine(var f: text; var s: string; unix: boolean);
procedure ReadLineNoCheck(var f: text; var s: string; unix: boolean);
procedure WriteEmptyLine(var f: text; unix: boolean);
procedure WriteLine(var f: text; s: string; unix: boolean);
procedure StreamWrite(F: PStream; s: string);
procedure StreamWriteln(F: PStream; s: string; Unix: boolean);
procedure GetString(F: PStream; var s: string);
function  ResetFile(var f: text): word;
function  RewriteFile(var f: text): word;
function  FlushFile(var f: text): word;
function  CloseFile(var f: text): word;
procedure logString(s: string);
procedure LogSection(S: string; BegSection: boolean);

function  SFNFExpand(Path: string): string;
{$IFDEF WINDOWS}
function  GetEnv(Env: string): string;
{$ENDIF}
function  IsWildcard(S: string): boolean;
{$IFDEF WINDOWS}
function  FileNameMatch(Name: Pchar; tn,te: string): boolean;
{$ELSE}
function  FileNameMatch(Name: string; tn,te: string): boolean;
{$ENDIF}
function  TruncateFilename(fname: string; MaxFileLen: integer): string;


Implementation

var
  LogFile: text;
  Logging_first: Boolean;
  Logging_Indent: integer;

{$IFDEF WINDOWS}
procedure message(s: string);
begin
  if length(s)=255 then dec(s[0]);
  S:=S+#0;
  messagebox(0,PChar(@S[1]),'',mb_ok);
end;
{$ENDIF}


{ LARGE drive support }

Function DriveSize(dr: char): Longint; { -1 not found, 1 Giga =>1 Giga }
var
  AXX,BXX,DXX,EMode: word;
  d: byte;
Begin
  dr:=UpCase(dr);
  if not (dr in ['A'..'Z']) then { Possible network drive? }
  begin
    DriveSize:=KGiga-K16; Exit;
  end;
  d:=ord(dr)-ord('A')+1;
{$IFDEF WINDOWS}
  EMode:=SetErrorMode(SEM_FailCriticalErrors or SEM_NoOpenFileErrorBox);
{$ENDIF}
  asm
    mov ah, $36
    mov dl, d
{$IFDEF WINDOWS}
    call dos3call
{$ELSE}             
    int $21
{$ENDIF}
    mov AXX, ax
    mov BXX, bx
    mov DXX, dx
  end;
{$IFDEF WINDOWS}
  SetErrorMode(EMode);
{$ENDIF}
  If AXX=$FFFF Then DriveSize:=-1 { Drive not found }
  Else If (BXX=$FFFF) or (Longint(axx)*bxx*dxx=KGiga-K16) Then
      DriveSize:=KGiga-K16
  Else DriveSize:=Longint(axx)*bxx*dxx;
End;                                { DriveSize }

Function DriveFree(dr: char): Longint; { -1 not found, 1 Giga =>1 Giga }
var
  AXX,BXX,CXX,Emode: word;
  d: byte;
Begin
  dr:=UpCase(dr);
  if not (dr in ['A'..'Z']) then { Possible network drive? }
  begin
    DriveFree:=KGiga-K16; Exit;
  end;
  d:=ord(dr)-ord('A')+1;
{$IFDEF WINDOWS}
  EMode:=SetErrorMode(SEM_FailCriticalErrors or SEM_NoOpenFileErrorBox);
{$ENDIF}
  asm
    mov ah, $36
    mov dl, d
{$IFDEF WINDOWS}
    call dos3call
{$ELSE}
    int $21
{$ENDIF}
    mov AXX, ax
    mov BXX, bx
    mov CXX, cx
  end;
{$IFDEF WINDOWS}
  SetErrorMode(EMode);
{$ENDIF}
  If AXX=$FFFF Then DriveFree:=-1 { Drive not found }
  Else If (BXX=$FFFF) or (Longint(axx)*bxx*cxx=KGiga-K16) Then
      DriveFree:=KGiga-K16
  Else DriveFree:=Longint(axx)*bxx*cxx;
End;                               { DriveFree }

{$IFNDEF WINDOWS}
function SetHandleCount(Nhandles: WORD): word;
var
  err: byte;
begin
  asm
        MOV     AX, $6700;
        MOV     BX, Nhandles
        INT     $21
        MOV     err, 0
        JNC     @l1
        MOV     err, 1          { Error! }
  @l1:
  end;
  if err=0 then SetHandleCount:=NHandles
  else SetHandleCount:=0;
end;                        { SetHandleCount }
{$ENDIF}

Function IsDirName(S: string): boolean;
Var
  i: byte;
  ch: char;
  ok: boolean;
begin                              { IsDirName }
  logstring('Enter IsDirName for "'+S+'"');
  ok:=true; IsDirName:=true;
  if Pos('\\',S)=1 then Exit;
  ch:=S[1];
  if Pos(':',S)>0 then
  begin
    ok:=Ready_Drive(ch);
  end;
  if ok and (Pos(':',S)>2) then
  begin
    ok:=false;
  end;
  if ok and (Pos(':',S)=2) then
  begin
    Delete(S,1,2);
    if Pos(':',S)>0 then
    begin
      ok:=false;
    end;
  end;
  if ok then
  begin
    for i:=1 to length(S) do
    begin
      ch:=S[i];
      if not (ch in FileNameSet+['.']) then ok:=false; 
    end;
  end;
  if ok then logstring('X IsDirName true') else logstring('X IsDirName false');
  IsDirName:=ok;
end;                               { IsDirName }

{$IFDEF WINDOWS}
function ready_drive(ch: char): boolean;
var
  sr : TSearchRec;
  F: array[0..10] of char;
  PrevErrMode: Word;
begin
  logsection('RDrive',true);
  PrevErrMode:=SetErrorMode(SEM_FailCriticalErrors or SEM_NoOpenFileErrorBox);
  StrPCopy(F,Upcase(ch) + ':\*'); FindFirst(F,AnyFile,Sr);
  if DosError<>0 then
  begin
    logstring('1');
    StrPCopy(F,Upcase(ch) + ':\*.*'); FindFirst(F,AnyFile,Sr);
  end;
  if DosError<>0 then logstring('2');
  Ready_Drive := (DosError = 0);
  SetErrorMode(PrevErrMode);
  logsection('RDrive',false);
end;                  { ready_drive }

{$ELSE}

function ready_drive(ch: char): boolean;
var
  sr : SearchRec;
begin
  FindFirst(Upcase(ch) + ':\*.*',AnyFile,Sr);
  Ready_Drive := (DosError = 0);
end;                { ready_drive }
{$ENDIF}

Function IsFileName(S: string): boolean;
Var
  i: byte;
  ch: char;
  ok: boolean;
  Dir,Name,Ext,tmp: Pstring;

procedure TidyUp;
begin
  Dispose(Ext); Dispose(Name); Dispose(Dir); Dispose(tmp);
  if ok then logsection('IsFileName true',false) else logsection('IsFileName false',false);
end;

begin                                 { IsFileName }
  ok:=true;
  New(tmp); New(Dir); New(Name); New(Ext);
  LFNFsplit(S,Dir,Name,Ext);
  logsection('IsFileName "'+S+'","'+Dir^+'","'+Name^+'","'+Ext^+'"',true);
  if Name^='' then
  begin
    IsFileName:=false; TidyUp;  Exit;
  end;
  ok:=(Dir^='') or IsDirName(Dir^);
  if ok then
  for i:=1 to length(Name^) do
  begin
    ch:=Name^[i];
    if not (ch in FileNameSet-[':']) then ok:=false;
  end;
  if ok then
  begin
    if (length(Ext^)>0) and (Ext^[length(Ext^)]='.') then
    begin
      tmp^:=Ext^; Delete(tmp^,length(tmp^),1); Ext^:=tmp^;
    end;
    if Ext^[1]='.' then
      for i:=2 to length(Ext^) do
      begin
        ch:=Ext^[i];
        if not (ch in FileNameSet-[':','.','\']) then ok:=false;
      end
    else if length(Ext^)>0 then ok:=false;
  end;
  IsFileName:=ok;
  TidyUp;
end;                                  { IsFileName }

Function FileSize(S: string): LongInt;
var
  Attrib: Word;
  Sr: SearchRec;
{$IFDEF WINDOWS}
  SS: array[0..255] of char;
{$ENDIF}
begin
  FileSize:=-1;
  if (S='') then Exit;
  S:=LFNShortName(S); if S='' then Exit;
  if (length(S)>1) and (S[2]=':') and not Ready_Drive(S[1]) then Exit;
{$IFDEF WINDOWS}
  StrPcopy(SS,S);
  FindFirst(SS,AnyFile and (not (sysfile or Directory)),Sr);
{$ELSE}
  FindFirst(S,AnyFile and (not (sysfile or Directory)),Sr);
{$ENDIF}
  if DosError=0 then FileSize:=Sr.size
  else FileSize:=-1;
end;                 { FileSize }

function GetFileTime(fname: string): longint;
var
  ftemp: file;
  time: longint;
begin
  GetFileTime:=-1;
  if (fname='') or (not LFNFileExist(fname)) then Exit;
  assign(ftemp,LFNShortName(fname));
  FileMode:=64;
  {$I-}
  reset(ftemp);
  if IoResult=0 then
  begin
    GetFTime(ftemp,Time); GetFileTime:=Time;
  end;
  close(ftemp); if IoResult=0 then;  
  {$I+}
end;                      { GetFileTime }

procedure Unique(Path: string; Var Fname: string);
var
  TempName : String;
  Okay : Boolean;
  NewHandle : Word;
  F : File;
begin                            { Unique }
  Path:=LFNShortName(Path);
  TempName := path; Fname:=''; Okay:=true;
  if (length(Path)>1) and (Path[2]=':')
      and not Ready_Drive(Path[1]) then Exit; 
  FillChar(TempName[Length(TempName)+1], 255-Length(TempName), #0);
  asm
    push    ds
    push    ss
    pop     ds
    lea     dx,TempName[1]
    mov     ah, $5a
    xor     cx,cx
  {$ifdef windows}
    call dos3call
  {$else}
    int     $21                 { Create temporary file. }
  {$endif}
    pop     ds
    jc      @failed
    mov     Okay,True
    mov     NewHandle,ax
    jmp     @done
@failed:
    mov     Okay,False
@done:
  end;
  if okay then
  begin
    while TempName[Length(TempName)+1] <> #0 do Inc(TempName[0]);
    Fname := TempName;
    asm
      mov ah,$3E
      mov bx,NewHandle
{$IFDEF WINDOWS}
      call    DOS3CALL
{$ELSE}
      INT     $21
{$ENDIF}
    end;
    assign(F,fname);
    Erase(F);
  end;
end;                                      { Unique }

function exist_ems: boolean;
begin
  exist_ems:=(ems_maxavail>0);
end;

function exist_xms: boolean;
begin
  exist_xms:=(xms_maxavail>0);
end;

function FreeSpace(fname: string): LongInt;
Var
  i: integer;
  l: longint;
begin
  if StrCmpI(fname,'[XMS]',1,1,255)=0 then
  begin
    FreeSpace:=xms_MaxAvail; Exit;
  end else if StrCmpI(fname,'[EMS]',1,1,255)=0 then
  begin
    FreeSpace:=ems_MaxAvail; Exit;
  end;
  if (fname='') or (not IsFileName(fname)) then
  begin
    FreeSpace:=-3; Exit;
  End;
  fname:=LFNShortName(fname);
  if fname[2]<>':' then fname:=SFNFExpand(fname);
  FreeSpace:=DriveFree(fname[1]);
end;                         { FreeSpace }

function ClusterSize(fname: string): longint;
var
  drive: byte;
  SecSiz,ClusSiz: word;
Begin
  ClusterSize:=16*1024;
  if (fname='') or (not IsFileName(fname)) then Exit;
  fname:=SFNFExpand(LFNShortName(fname));
  if not (UpCase(fname[1]) in ['A'..'Z']) then Exit; { Network? }
  drive:=Ord(UpCase(fname[1]))-Ord('A')+1;
  asm
    mov ah, $36
    mov dl, drive
{$IFDEF WINDOWS}
    call dos3call
{$ELSE}
    int $21
{$ENDIF}
    mov ClusSiz, ax
    mov SecSiz, cx
  end;
  ClusterSize:=ClusSiz*SecSiz;
end;                        { ClusterSize }
 
procedure FindFile(Var S: string; name: string; dirs: string);
var
  Index: Byte;
  i: integer;
  D,N,E,tmp: Pstring;

procedure TidyUp;
begin
  Dispose(E); Dispose(N); Dispose(D); Dispose(tmp);
end;

begin                                 { FindFile }
  S:='';
  if name='' then Exit;
  New(tmp); New(D); New(N); New(E);
  LFNFsplit(name,D,N,E);
  if D^<>'' then
  begin
    S:=LFNFSearch(N^+E^,D^);
    if S<>'' then S:=LFNfexpand(D^)+N^+E^;
    TidyUp; Exit;
  end;
  if dirs='' then Dirs:='.';
  index:=1;
  repeat
    WrdToken(tmp^,Dirs,';',Index);
    if tmp^<>'' then
    begin
      if tmp^[length(tmp^)]<>'\' then tmp^:=tmp^+'\';
      S:=LFNFsearch(name,tmp^);
      if S<>'' then S:=LFNfexpand(S);
    end;
  until (S<>'') or (Index=0);
  TidyUp;
end;                                 { FindFile }

function IsUnixFile(var f: text; fname: string) : boolean;
var
  ch,lastch: char;
  ReadEOL,btmp: boolean;
  Attrib: Word;
begin
  if fname='' then
  begin
    IsUnixFile:=false; Exit;
  end;
  fname:=SFNfexpand(LFNShortName(fname)); StrLwr(fname);
  btmp:=(fname<>'') and (Pos(fname[1],UnixDrives)>0);
  GetFAttr(f,Attrib);
  if DosError<>0 then
  begin
    IsUnixFile:=btmp; Exit;
  end;
  {$I-}
  reset(f);
  if IoResult<>0 then
  begin
    {$I+}
    IsUnixFile:=false;
    Exit;
  end;
  {$I+}
  lastch:=#0; ReadEOL:=false;
  while not (eof(f) or (lastch=#10)) do
  begin
    read(f,ch);
    if ch=#10 then Btmp:=(LastCh<>#13);
    lastch:=ch;
  end;
  IsUnixFile:=btmp;
end;                { IsUnixFile }

function IsUnixStream(f: PStream; fname: string) : boolean;
var
  ch,lastch: char;
  ReadEOL,btmp: boolean;
  Attrib: Word;
begin
  if fname='' then
  begin
    IsUnixStream:=false; Exit;
  end;
  fname:=SFNfexpand(LFNShortName(fname)); StrLwr(fname);
  btmp:=(fname<>'') and (Pos(fname[1],UnixDrives)>0);
  lastch:=#0; ReadEOL:=false;
  while (F^.status=stOK) and (lastch<>#10) do
  begin
    F^.read(ch,1);
    if ch=#10 then Btmp:=(LastCh<>#13);
    lastch:=ch;
  end;
  if F^.status<>stOK then F^.reset;
  IsUnixStream:=btmp;
end;                     { IsUnixStream }

procedure SkipOneLine(var f: text; Unix: boolean);
var
  ch: char;
begin
  {$I-}
  if Unix then
  begin
    ch:=#0;
    DosError:=0;
    if not ReachedEol then
      while (ch<>#10) and (not eof(f)) and (DosError=0) do
      begin
        read(f,ch); DosError:=IoResult;
      end;
  end else
  begin
    readln(f); DosError:=IoResult;
  end;
  {$I+}
  ReachedEol:=false;
end;                     { SkipOneLine }

procedure ReadString(var f: text; var s: string; unix: boolean);
var
  ch: char;
  i: integer;
  ok: boolean;
begin
  s:=''; ok:=true;
  {$I-}
  if eof(f) then ok:=false;
  if IoResult<>0 then ok:=false;
  {$I+}
  if not ok then Exit;
  {$I-}
  if Unix then
  begin
    read(f,ch);
    DosError:=IoResult; if DosError<>0 then Exit;
    i:=1;
    while (ch<>#10) and (not eof(f)) and (i<=255) do
    begin
      s[i]:=ch; inc(i); 
      if i<=255 then read(f,ch); 
      DosError:=IoResult; if DosError<>0 then Exit;
    end;
    i:=i-1;
    if (i>0) and (s[i]=#13) then s[0]:=char(i-1)
    else s[0]:=char(i);
    ReachedEol:=(ch=#10);
  end else
  begin
    read(f,s);
    ReachedEol:=Eoln(f);
    DosError:=IoResult;
  end;
  {$I+}
end;                 { ReadString }

procedure ReadLine(var f: text; var s: string; unix: boolean);
var
  ch: char;
  i: integer;
  ok: boolean;
begin
  s:=''; ok:=true;
  {$I-}
  if eof(f) then ok:=false;
  if IoResult<>0 then ok:=false;
  {$I+}
  if not ok then Exit;
  {$I-}
  if Unix then
  begin
    read(f,ch);
    DosError:=IoResult; if DosError<>0 then Exit;
    i:=1;
    while (ch<>#10) and (not eof(f)) do
    begin
      if i<=255 then
      begin
        s[i]:=ch; inc(i); 
      end;
      read(f,ch); 
      DosError:=IoResult; if DosError<>0 then Exit;
    end;
    i:=i-1;
    if (i>0) and (s[i]=#13) then s[0]:=char(i-1)
    else s[0]:=char(i);
  end else
  begin
    readln(f,s);
    DosError:=IoResult;
  end;
  {$I+}
  ReachedEol:=false;
end;                          { ReadLine }

procedure ReadLineNoCheck(var f: text; var s: string; unix: boolean);
var
  ch: char;
  i: byte;
begin
  s:='';
  {$I-}
  if Unix then
  begin
    read(f,ch);
    DosError:=IoResult; if DosError<>0 then Exit;
    i:=0;
    while (ch<>#10) and (not eof(f)) do
    begin
      if i<255 then
      begin
        inc(i); s[i]:=ch;
      end;
      read(f,ch); 
      DosError:=IoResult; if DosError<>0 then Exit;
    end;
    if (i>0) and (s[i]=#13) then s[0]:=char(i-1)
    else s[0]:=char(i);
  end else
  begin
    readln(f,s);
    DosError:=IoResult;
  end;
  {$I+}
  ReachedEol:=false;
end;                    { ReadLineNoCheck }

procedure WriteEmptyLine(var f: text; unix: boolean);
begin
  {$I-}
  if Unix then write(f,#10)
  else writeln(f);
  DosError:=IoResult;
  {$I+}
end;

procedure WriteLine(var f: text; s: string; unix: boolean);
begin
  {$I-}
  if Unix then write(f,s,#10)
  else writeln(f,s);
  DosError:=IoResult;
  {$I+}
end;

procedure StreamWrite(F: PStream; s: string);
begin
  if s[0]<>#0 then F^.write(s[1],length(s));
end;

procedure StreamWriteln(F: PStream; s: string; Unix: boolean);
begin
  if s[0]<>#0 then F^.write(s[1],length(s));
  if Unix then S:=#10 else S:=#13#10;
  F^.write(s[1],length(s));
end;

procedure GetString(F: PStream; var s: string);
begin
  F^.read(s[0],1); if s[0]<>#0 then F^.read(s[1],Ord(s[0]));
end;

function ResetFile(var f: text): word;
begin
  FileMode:=64;
  {$I-}
  reset(f);
  DosError:=IoResult; ResetFile:=DosError;
  {$I+}
  ReachedEol:=false;
end;                    { ResetFile }

function RewriteFile(var f: text): word;
begin
  {$I-}
  rewrite(f);
  DosError:=IoResult; RewriteFile:=DosError;
  {$I+}
end;

function FlushFile(var f: text): word;
begin
  {$I-}
  flush(f);
  DosError:=IoResult; FlushFile:=DosError;
  {$I+}
end;

function CloseFile(var f: text): word;
begin
  {$I-}
  close(f);
  DosError:=IoResult; CloseFile:=DosError;
  {$I+}
end;

procedure LogString(s: string);
var
  Dir,Name,Ext: PString;
  i: integer;
begin
{$IFDEF LOGFILE}
  if not logging_on then exit;
  New(Dir); New(Name); New(Ext);
  if Logging_first then
  begin
    LFNFsplit(SFNFExpand(ParamStr(0)),Dir,Name,Ext);
    Assign(LogFile,Dir^+Name^+'.lg');
    Logging_Indent:=0;
    rewrite(LogFile);
  end else Append(LogFile);
  for i:=1 to Logging_Indent do  write(LogFile,' ');
  writeln(LogFile,s);
  close(LogFile);
  Logging_first:=false;
  Dispose(Ext); Dispose(Name); Dispose(Dir);
{$ENDIF}
end;           { logging }

procedure LogSection(S: string; BegSection: boolean);
begin
{$IFDEF LOGFILE}
  if not logging_on then exit;
  if BegSection then
  begin
    LogString('Enter '+S);
    Logging_indent:=Logging_indent+2;
  end else
  begin
    Logging_Indent:=Logging_indent-2;
    LogString('Exit '+S);
  end;
{$ENDIF}
end;                   { LogIndent }

{$IFDEF WINDOWS}
function SFNFExpand(Path: string): string;
var
  A,B: PChar;
begin
  GetMem(A,256); GetMem(B,256);
  StrPCopy(A,Path);
  FileExpand(B,A);
  if B[0]=#0 then SFNFExpand:=''
  else SFNFExpand:=StrPas(B);
  FreeMem(B,256); FreeMem(A,256);
end;                    { FExpand }

function GetEnv(Env: string): string;
var
  i,len: integer;
  P: Pchar;
begin
  GetEnv:=''; if Env='' then Exit;

  len:=length(Env);
  for i:=1 to len do Env[i-1]:=Env[i]; Env[len]:=#0;
  P:=GetEnvVar(PChar(@Env));
  if P=Nil then GetEnv:=''
  else GetEnv:=StrPas(P); 
end;                 { GetEnv }
{$ELSE}

function SFNFExpand(Path: string): string;
begin
  SFNFExpand:=FExpand(Path);
end;
{$ENDIF}

function IsWildcard(S: string): boolean;
begin
  IsWildcard:=(Pos('*',S)+Pos('?',S)+Pos('[',S)>0);
end;

{$IFDEF WINDOWS}
function FileNameMatch(Name: Pchar; tn,te: string): boolean;
{$ELSE}
function FileNameMatch(Name: string; tn,te: string): boolean;
{$ENDIF}
var
  D,N,E: PString;
  m: boolean;
begin
  FilenameMatch:=false;
  New(D); New(N); New(E);
{$IFDEF WINDOWS}
  LFNFSplit(StrPas(Name),D,N,E);
{$ELSE}
  LFNFSplit(Name,D,N,E);
{$ENDIF}
  M:=Match(tn[1],length(tn),N^[1],length(N^),false);
  while (not M) and (tn<>'') and (tn[length(tn)]='?') do
  begin
    dec(tn[0]);
    M:=Match(tn[1],length(tn),N^[1],length(N^),false);
  end;
  if not M then Exit;
  M:=Match(te[1],length(te),E^[1],length(E^),false);
  while (not M) and (te<>'') and (te[length(te)]='?') do
  begin
    dec(te[0]);
    M:=Match(te[1],length(te),E^[1],length(E^),false);
  end;
  FilenameMatch:=M;
  Dispose(E); Dispose(N); Dispose(D);
end;                        { FileNameMatch }

function TruncateFilename(fname: string; MaxFileLen: integer): string;
var
  left,right: integer;
begin
  if length(fname)>MaxFileLen then
  begin
    fname:='..'+Copy(fname,length(fname)-MaxFileLen+3,255);
  end;
  TruncateFilename:=fname;

  {
  if length(fname)>MaxLen then
  begin
    left:=(MaxLen-2) div 2; 
    while (left>0) and (fname[left]<>'\') do dec(left);
    right:=length(fname)-left+2;
    while (right<=length(fname)) and (fname[right]<>'\') do inc(right);
    if right>length(fname) then right:=(MaxLen-2) div 2 + 1;
    fname:=Copy(fname,1,left)+'..'+Copy(fname,right,255);
  end;
  TruncateFilename:=fname;
  }
end;             { TruncateFilename }


begin
  FileNameSet:=['!','#'..')',#45,#46,'0'..':','@'..'Z','\','`'..#123,
                #125,'~','_',#128..#255];
  if LFNAble then FilenameSet:=FilenameSet+[' '];
  ReachedEol:=false;
  Logging_first:=true;
end.
